<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class ManoObraTerceros extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('mano_obra_terceros', function (Blueprint $table) {
            $table->increments('mot_pk_id');
            $table->integer('con_fk_id');
            $table->string('ins_fk_id', 50);
            $table->integer('mot_ano');
            $table->integer('mot_mes');
            $table->string('mot_nit_tercero', 20);
            $table->string('mot_razon_social', 500);
            $table->float('mot_costo');

            $table->foreign('con_fk_id')->references('con_pk_id')->on('contrato')->onDelete('cascade');
            $table->foreign(['ins_fk_id', 'con_fk_id'])->references(['ins_pk_id', 'con_fk_id'])->on('instituciones')->onDelete('cascade');

            $table->index(['con_fk_id', 'ins_fk_id', 'mot_ano', 'mot_mes']);
            $table->index(['con_fk_id', 'ins_fk_id', 'mot_ano', 'mot_mes', 'mot_nit_tercero']);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('mano_obra_terceros');
    }
}
