<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class ManoObraDirecta extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('mano_obra_directa', function (Blueprint $table) {
            $table->increments('mod_pk_id');
            $table->integer('con_fk_id');
            $table->string('ins_fk_id', 50);
            $table->integer('mod_ano');
            $table->integer('mod_mes');
            $table->integer('cco_fk_id');
            $table->integer('act_fk_id');
            $table->integer('mob_fk_id');
            $table->float('mod_costo')->nullable();

            $table->foreign('con_fk_id')->references('con_pk_id')->on('contrato')->onDelete('cascade');
            $table->foreign(['ins_fk_id', 'con_fk_id'])->references(['ins_pk_id', 'con_fk_id'])->on('instituciones')->onDelete('cascade');
            $table->foreign('cco_fk_id')->references('cco_pk_id')->on('centros_costo')->onDelete('cascade');
            $table->foreign('act_fk_id')->references('act_pk_id')->on('actividades')->onDelete('cascade');
            $table->foreign('mob_fk_id')->references('mob_pk_id')->on('mano_obra')->onDelete('cascade');

            $table->unique(['con_fk_id', 'ins_fk_id', 'mod_ano', 'mod_mes', 'cco_fk_id', 'act_fk_id', 'mob_fk_id']);

            $table->index(['con_fk_id', 'ins_fk_id', 'mod_ano', 'mod_mes'], 'mod_index1');
            $table->index(['con_fk_id', 'ins_fk_id', 'mod_ano', 'mod_mes', 'cco_fk_id'], 'mod_index2');
            $table->index(['con_fk_id', 'ins_fk_id', 'mod_ano', 'mod_mes', 'cco_fk_id', 'act_fk_id'], 'mod_index3');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('mano_obra_directa');
    }
}
